/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class myclass {
    public static String uName;
    public static String uPassword;
    public static String cacheName;
    public static String cacheType;
    public static String cacheFinalCoords;
    public static String cachePostedCoords;
    public static boolean cachePostedIsPhysical;
    public static String cachePlacedBy;
    public static Date cacheDatePlaced;
    public static String cacheCountry;
    public static String cacheState;
    public static String cacheSummary;
    public static String cacheDescription;
    public static String cacheBackgroundImage;
    public static String cacheHint;
    public static boolean cachePremium;
    public static String cacheSize;
    public static String cacheDifficulty;
    public static String cacheTerrain;
    public static List<String> cacheAttributes;
    public static List<String> cacheNegAttributes;
    public static String cacheReviewerNotes;
    public static boolean cacheAgreeToTerms;
    public static boolean cacheSubmitForReview;
    public static String importFileName;
    public static WebDriver driver;
    public static double smileyLat;
    public static double smileyLon;
    public static String gcCode;
    public static double finalLat;
    public static double finalLon;

    static {
        smileyLat = 0.0;
        smileyLon = 0.0;
        gcCode = "";
        finalLat = 0.0;
        finalLon = 0.0;
    }

    private static void createAndShowGUI() {
        final JFrame frame = new JFrame("");
        JTextField field1 = new JTextField("");
        JPasswordField field2 = new JPasswordField(20);
        JCheckBox agreeToTerms = new JCheckBox("I have read and agree to the Cache Listing Requirements Guidelines.");
        JCheckBox submitForReview = new JCheckBox("Check to automatically submit to the Reviewer, else you will need to submit for review");
        JButton b = new JButton("Upload File To Process");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FileDialog fd = new FileDialog((Frame)frame, "LOAD");
                fd.setDirectory("C:\\");
                fd.setFile("*.xlsx");
                fd.setFilenameFilter((dir, name) -> name.endsWith(".xlsx"));
                fd.setMode(0);
                fd.setVisible(true);
                importFileName = String.valueOf(fd.getDirectory()) + fd.getFile();
            }
        });
        JPanel panel = new JPanel(new GridLayout(0, 1));
        panel.add(new JLabel("Geocaching.com Username:"));
        panel.add(field1);
        panel.add(new JLabel("Geocaching.com Password:"));
        panel.add(field2);
        panel.add(b);
        panel.add(agreeToTerms);
        panel.add(submitForReview);
        int result = JOptionPane.showConfirmDialog(null, panel, "Mass New Cache Creation", 2, -1);
        if (result == 0) {
            System.out.println(String.valueOf(field1.getText()) + " " + ((JTextComponent)field2).getText());
            uName = field1.getText();
            uPassword = ((JTextComponent)field2).getText();
            cacheAgreeToTerms = agreeToTerms.isSelected();
            cacheSubmitForReview = submitForReview.isSelected();
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                myclass.createAndShowGUI();
                System.out.println("." + uName + ".");
                if (uName == null || uName.trim().equals("") || uPassword == null || uPassword.trim().equals("")) {
                    JOptionPane.showMessageDialog(null, "You need to provide both your Geocaching.com Username and Password for script to login and work. Information is not saved.");
                    System.exit(0);
                }
                if (importFileName == null || importFileName == "") {
                    JOptionPane.showMessageDialog(null, "Must Provide a filled in templated document to upload your new caches.");
                    System.exit(0);
                }
                if (cacheAgreeToTerms) {
                    driver = new ChromeDriver();
                    driver.get("https://www.geocaching.com/account/signin");
                    WebElement element = driver.findElement(By.name((String)"UsernameOrEmail"));
                    element.sendKeys(new CharSequence[]{uName});
                    element = driver.findElement(By.name((String)"Password"));
                    element.sendKeys(new CharSequence[]{uPassword});
                    element.submit();
                    try {
                        myclass.processImportListFile();
                        driver.quit();
                        driver.close();
                        System.exit(0);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, "ERROR: " + e.toString());
                        driver.quit();
                        driver.close();
                        System.exit(0);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "You must acknowledge that you agree to Geocaching.com's Terms of Agreement and Cache Listing Requirements");
                    System.exit(0);
                }
            }
        });
    }

    private static boolean processImportListFile() throws IOException {
        FileInputStream file = new FileInputStream(new File(importFileName));
        System.out.println("here");
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)file);
        System.out.println("here2");
        XSSFSheet sheet = workbook.getSheetAt(0);
        Iterator rowIterator = sheet.iterator();
        int rowCounter = 0;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            System.out.println(rowCounter);
            if (rowCounter != 0) {
                Iterator cellIterator = row.cellIterator();
                Cell cell = (Cell)cellIterator.next();
                cacheName = cell.getStringCellValue().trim();
                if (cacheName == null || cacheName.trim().equals("")) {
                    driver.quit();
                    JOptionPane.showMessageDialog(null, "Reached Last Cache Row");
                    System.exit(0);
                }
                cell = (Cell)cellIterator.next();
                cacheType = cell.getStringCellValue().trim();
                cell = (Cell)cellIterator.next();
                cacheFinalCoords = cell.getStringCellValue().trim();
                cell = (Cell)cellIterator.next();
                cachePostedCoords = cell.getStringCellValue().trim();
                cell = (Cell)cellIterator.next();
                if (cell.getStringCellValue().trim().equals("Physical")) {
                    cachePostedIsPhysical = true;
                } else if (cell.getStringCellValue().trim().equals("Virtual")) {
                    cachePostedIsPhysical = false;
                }
                cell = (Cell)cellIterator.next();
                cachePlacedBy = cell.getStringCellValue().trim();
                cell = (Cell)cellIterator.next();
                cacheDatePlaced = cell.getDateCellValue();
                cell = (Cell)cellIterator.next();
                cacheCountry = cell.getStringCellValue().trim();
                cell = (Cell)cellIterator.next();
                cacheState = cell.getStringCellValue().trim();
                cell = (Cell)cellIterator.next();
                cacheSummary = cell.getStringCellValue().trim();
                cell = (Cell)cellIterator.next();
                cacheDescription = cell.getStringCellValue().trim();
                cell = (Cell)cellIterator.next();
                cacheBackgroundImage = cell.getStringCellValue().trim();
                cell = (Cell)cellIterator.next();
                cacheHint = cell.getStringCellValue().trim();
                cell = (Cell)cellIterator.next();
                if (cell.getStringCellValue().equals("Yes")) {
                    cachePremium = true;
                } else if (cell.getStringCellValue().equals("No")) {
                    cachePremium = false;
                }
                cell = (Cell)cellIterator.next();
                cacheSize = cell.getStringCellValue().trim().equals("Regular") ? "Medium" : cell.getStringCellValue().trim();
                cell = (Cell)cellIterator.next();
                cacheDifficulty = cell.getStringCellValue().trim();
                cell = (Cell)cellIterator.next();
                cacheTerrain = cell.getStringCellValue().trim();
                cell = (Cell)cellIterator.next();
                cacheAttributes = Arrays.asList(cell.getStringCellValue().trim().split(", "));
                cell = (Cell)cellIterator.next();
                cacheNegAttributes = Arrays.asList(cell.getStringCellValue().trim().split(", "));
                cell = (Cell)cellIterator.next();
                cacheReviewerNotes = cell.getStringCellValue().trim();
                if (cacheName != "" && cacheType != "" && cacheFinalCoords != "" && cacheCountry != "" && cacheState != "" && cacheSummary != "" && cacheSize != "" && cacheDifficulty != "" && cacheTerrain != "" && cacheReviewerNotes != "") {
                    try {
                        myclass.runNewCacheScript();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, "ERROR: " + e.toString());
                        driver.quit();
                        driver.close();
                        System.exit(0);
                    }
                }
            }
            ++rowCounter;
        }
        System.out.println("end");
        workbook.close();
        file.close();
        return false;
    }

    private static void runNewCacheScript() throws InterruptedException {
        driver.get("https://www.geocaching.com/hide/planning.aspx");
        new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                return d.getTitle().toLowerCase().startsWith("geocaching > submit a geocache");
            }
        });
        driver.findElement(By.id((String)"btnContinue")).click();
        WebElement element = driver.findElement(By.cssSelector((String)"[aria-describedby='dialog-draft']"));
        if (element.getAttribute("aria-describedby").equals("dialog-draft")) {
            List draftButtons = element.findElements(By.tagName((String)"button"));
            for (WebElement item : draftButtons) {
                if (!item.getText().equals("Start Over")) continue;
                item.click();
                break;
            }
        }
        if (cacheType.equals("Traditional")) {
            new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver d) {
                    return d.findElement(By.id((String)"ct_Traditional")).isDisplayed();
                }
            });
            if (driver.findElement(By.className((String)"btn-danger")).isDisplayed()) {
                driver.findElement(By.className((String)"btn-danger")).click();
            }
            driver.findElement(By.id((String)"ct_Traditional")).click();
            element = driver.findElement(By.id((String)"uxCoordParse"));
            element.sendKeys(new CharSequence[]{cacheFinalCoords});
            if (driver.findElement(By.id((String)"map-disclaimer")).isDisplayed()) {
                driver.findElement(By.id((String)"btnUnderstand")).click();
            }
            new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver d) {
                    return d.findElement(By.id((String)"searchButton")).isDisplayed();
                }
            });
            driver.findElement(By.id((String)"searchButton")).click();
            Thread.sleep(500L);
            driver.findElement(By.id((String)"btnContinue")).click();
        } else if (cacheType.equals("Mystery")) {
            if (driver.findElement(By.id((String)"moreToggle")).isDisplayed()) {
                driver.findElement(By.id((String)"moreToggle")).click();
            }
            new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver d) {
                    return d.findElement(By.id((String)"ct_Mystery")).isDisplayed();
                }
            });
            driver.findElement(By.id((String)"ct_Mystery")).click();
            new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver d) {
                    return d.findElement(By.id((String)"addStage")).isDisplayed();
                }
            });
            driver.findElement(By.id((String)"addStage")).findElement(By.tagName((String)"button")).click();
            List physicalRadio = driver.findElements(By.name((String)"physical-stage-1"));
            for (WebElement item : physicalRadio) {
                if (item.getAttribute("value").equals("false") && !cachePostedIsPhysical) {
                    item.click();
                    continue;
                }
                if (!item.getAttribute("value").equals("true") || !cachePostedIsPhysical) continue;
                item.click();
            }
            driver.findElement(By.id((String)"stage1Coords")).sendKeys(new CharSequence[]{cachePostedCoords});
            driver.findElement(By.id((String)"stageFinalCoords")).sendKeys(new CharSequence[]{cacheFinalCoords});
            Thread.sleep(100L);
            driver.findElement(By.id((String)"stage1Coords")).click();
            Thread.sleep(100L);
            driver.findElement(By.id((String)"stageFinalCoords")).click();
            Thread.sleep(1500L);
            driver.findElement(By.id((String)"btnContinue")).click();
        } else {
            System.exit(0);
        }
        new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                return d.findElement(By.name((String)"parking")).isDisplayed();
            }
        });
        Thread.sleep(100L);
        driver.findElement(By.id((String)"btnContinue")).click();
        driver.findElement(By.id((String)"ctl00_ContentBody_tbGeocacheName")).sendKeys(new CharSequence[]{cacheName});
        Select countrySelect = new Select(driver.findElement(By.id((String)"ddCountry")));
        countrySelect.selectByVisibleText(cacheCountry);
        new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                WebElement e = d.findElement(By.id((String)"ddState"));
                return e.isEnabled();
            }
        });
        Select stateSelect = new Select(driver.findElement(By.id((String)"ddState")));
        stateSelect.selectByVisibleText(cacheState);
        List inputFormInputs = driver.findElements(By.tagName((String)"input"));
        for (WebElement item : inputFormInputs) {
            if (item.getAttribute("id").equals("ctl00_ContentBody_tbPlacedBy")) {
                item.clear();
                item.sendKeys(new CharSequence[]{cachePlacedBy});
                continue;
            }
            if (item.getAttribute("id").equals("ctl00_ContentBody_tbDate")) {
                SimpleDateFormat ft = new SimpleDateFormat("MM/dd/yyyy");
                item.clear();
                item.sendKeys(new CharSequence[]{ft.format(cacheDatePlaced)});
                continue;
            }
            if (item.getAttribute("id").equals("ctl00_ContentBody_tbBackgroundUrl")) {
                item.sendKeys(new CharSequence[]{cacheBackgroundImage});
                continue;
            }
            if (item.getAttribute("id").equals("ctl00_ContentBody_rblMemberLevel_1")) {
                if (!cachePremium) continue;
                item.click();
                continue;
            }
            if (!item.getAttribute("id").equals("ctl00_ContentBody_cbAgreement")) continue;
            item.click();
        }
        driver.findElement(By.id((String)"tbHint")).sendKeys(new CharSequence[]{cacheHint});
        driver.findElement(By.id((String)"btnContinue")).click();
        new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                return d.findElement(By.id((String)"ctl00_ContentBody_imgExampleLarge")).isDisplayed();
            }
        });
        String cacheSizeIdString = "ctl00_ContentBody_imgExample" + cacheSize;
        driver.findElement(By.id((String)cacheSizeIdString)).click();
        List difSelElement = driver.findElements(By.className((String)"difficulty-selector"));
        List difHalfList = ((WebElement)difSelElement.get(0)).findElements(By.className((String)"half-step"));
        switch (cacheDifficulty) {
            case "1": {
                driver.findElement(By.className((String)"d1")).click();
                break;
            }
            case "1.5": {
                ((WebElement)difHalfList.get(0)).click();
                break;
            }
            case "2": {
                driver.findElement(By.className((String)"d2")).click();
                break;
            }
            case "2.5": {
                ((WebElement)difHalfList.get(1)).click();
                break;
            }
            case "3": {
                driver.findElement(By.className((String)"d3")).click();
                break;
            }
            case "3.5": {
                ((WebElement)difHalfList.get(2)).click();
                break;
            }
            case "4": {
                driver.findElement(By.className((String)"d4")).click();
                break;
            }
            case "4.5": {
                ((WebElement)difHalfList.get(3)).click();
                break;
            }
            case "5": {
                driver.findElement(By.className((String)"d5")).click();
            }
        }
        List terHalfList = ((WebElement)difSelElement.get(1)).findElements(By.className((String)"half-step"));
        switch (cacheTerrain) {
            case "1": {
                driver.findElement(By.className((String)"t1")).click();
                driver.findElement(By.id((String)"confirmWheelchair")).click();
                break;
            }
            case "1.5": {
                ((WebElement)terHalfList.get(0)).click();
                break;
            }
            case "2": {
                driver.findElement(By.className((String)"t2")).click();
                break;
            }
            case "2.5": {
                ((WebElement)terHalfList.get(1)).click();
                break;
            }
            case "3": {
                driver.findElement(By.className((String)"t3")).click();
                break;
            }
            case "3.5": {
                ((WebElement)terHalfList.get(2)).click();
                break;
            }
            case "4": {
                driver.findElement(By.className((String)"t4")).click();
                break;
            }
            case "4.5": {
                ((WebElement)terHalfList.get(3)).click();
                break;
            }
            case "5": {
                driver.findElement(By.className((String)"t5")).click();
            }
        }
        List attributeList = driver.findElement(By.id((String)"ctl00_ContentBody_ctlAttributes_dtlAttributeIcons")).findElements(By.tagName((String)"img"));
        for (WebElement item : attributeList) {
            switch (item.getAttribute("id")) {
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl00_imgAttribute": {
                    if (cacheAttributes.contains("Scenic View")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("Not Scenic View")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl01_imgAttribute": {
                    if (cacheAttributes.contains("Dogs")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Dogs")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl02_imgAttribute": {
                    if (!cacheAttributes.contains("Access or Parking Fee")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl03_imgAttribute": {
                    if (!cacheAttributes.contains("Climbing Gear")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl04_imgAttribute": {
                    if (!cacheAttributes.contains("Boat")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl05_imgAttribute": {
                    if (!cacheAttributes.contains("Scuba Gear")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl06_imgAttribute": {
                    if (cacheAttributes.contains("Recommended For Kids")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("Not Recommended For Kids")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl07_imgAttribute": {
                    if (cacheAttributes.contains("Less Than an Hour")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("More Than an Hour")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl08_imgAttribute": {
                    if (cacheAttributes.contains("Difficult Climbing")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("Not Difficult Climbing")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl09_imgAttribute": {
                    if (!cacheAttributes.contains("May Require Wading")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl10_imgAttribute": {
                    if (!cacheAttributes.contains("May Require Swimming")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl11_imgAttribute": {
                    if (cacheAttributes.contains("Available At All Times")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("Not Available At All Times")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl12_imgAttribute": {
                    if (cacheAttributes.contains("Recommended At Night")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("Not Recommended At Night")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl13_imgAttribute": {
                    if (cacheAttributes.contains("Available During Winter")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("Not Available During Winter")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl14_imgAttribute": {
                    if (!cacheAttributes.contains("Cliff / Falling Rocks")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl15_imgAttribute": {
                    if (!cacheAttributes.contains("Hunting")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl16_imgAttribute": {
                    if (!cacheAttributes.contains("Dangerous Area")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl17_imgAttribute": {
                    if (cacheAttributes.contains("Wheelchair Accessable")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("Not Wheelchair Accessable")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl18_imgAttribute": {
                    if (cacheAttributes.contains("Camping Available")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Camping")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl19_imgAttribute": {
                    if (cacheAttributes.contains("Bicycles")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Bicycles")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl20_imgAttribute": {
                    if (cacheAttributes.contains("Motorcycles")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Motorcycles")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl21_imgAttribute": {
                    if (cacheAttributes.contains("Quads")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Quads")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl22_imgAttribute": {
                    if (cacheAttributes.contains("Off-Road Vehicles")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Off-Road Vechicles")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl23_imgAttribute": {
                    if (cacheAttributes.contains("Snowmobiles")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Snowmobiles")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl24_imgAttribute": {
                    if (cacheAttributes.contains("Campires")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Campires")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl25_imgAttribute": {
                    if (cacheAttributes.contains("Poisonous Plants")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Poisonous Plants")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl26_imgAttribute": {
                    if (!cacheAttributes.contains("Thorns")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl27_imgAttribute": {
                    if (!cacheAttributes.contains("Dangerous Animals")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl28_imgAttribute": {
                    if (!cacheAttributes.contains("Ticks")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl29_imgAttribute": {
                    if (!cacheAttributes.contains("Abandoned Mines")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl30_imgAttribute": {
                    if (cacheAttributes.contains("Parking Available")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Parking Available")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl31_imgAttribute": {
                    if (!cacheAttributes.contains("Public Transportation")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl32_imgAttribute": {
                    if (cacheAttributes.contains("Picnic Tables")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Picnic Tables")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl33_imgAttribute": {
                    if (cacheAttributes.contains("Horses")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Horses")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl34_imgAttribute": {
                    if (cacheAttributes.contains("Drinking Water Nearby")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Drinking Water Nearby")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl35_imgAttribute": {
                    if (cacheAttributes.contains("Public Restrooms Nearby")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Public Restrooms Nearby")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl36_imgAttribute": {
                    if (cacheAttributes.contains("Telephone Nearby")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Telephone Nearby")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl37_imgAttribute": {
                    if (cacheAttributes.contains("Stroller Accessible")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("Not Stroller Accessible")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl38_imgAttribute": {
                    if (!cacheAttributes.contains("Watch For Livestock")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl39_imgAttribute": {
                    if (cacheAttributes.contains("Stealth Required")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Stealth Required")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl40_imgAttribute": {
                    if (!cacheAttributes.contains("Flashlight Required")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl41_imgAttribute": {
                    if (cacheAttributes.contains("Truck Driver/RV")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Truck Driver/RV")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl42_imgAttribute": {
                    if (!cacheAttributes.contains("UV Light Required")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl43_imgAttribute": {
                    if (!cacheAttributes.contains("Snowshoes")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl44_imgAttribute": {
                    if (!cacheAttributes.contains("Cross Country Skis")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl45_imgAttribute": {
                    if (!cacheAttributes.contains("Special Tool Required")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl46_imgAttribute": {
                    if (cacheAttributes.contains("Night Cache")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("Not Night Cache")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl47_imgAttribute": {
                    if (cacheAttributes.contains("Park and Grab")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("Not Park and Grab")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl48_imgAttribute": {
                    if (cacheAttributes.contains("Abandoned Structure")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Abandoned Structure")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl49_imgAttribute": {
                    if (cacheAttributes.contains("Short Hike")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("Not Short Hike")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl50_imgAttribute": {
                    if (cacheAttributes.contains("Medium Hike")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("Not Medium Hike")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl51_imgAttribute": {
                    if (cacheAttributes.contains("Long Hike")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("Not Long Hike")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl52_imgAttribute": {
                    if (cacheAttributes.contains("Fuel Nearby")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Fuel Nearby")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl53_imgAttribute": {
                    if (cacheAttributes.contains("Food Nearby")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Food Nearby")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl54_imgAttribute": {
                    if (!cacheAttributes.contains("Wireless Beacon")) break;
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl55_imgAttribute": {
                    if (cacheAttributes.contains("Field Puzzle")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Field Puzzle")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl56_imgAttribute": {
                    if (cacheAttributes.contains("Significant Hike")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("Not Significant Hike")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl57_imgAttribute": {
                    if (cacheAttributes.contains("Seasonal Access")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Seasonal Access")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl58_imgAttribute": {
                    if (cacheAttributes.contains("Tourist Friendly")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("Not Tourist Friendly")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl59_imgAttribute": {
                    if (cacheAttributes.contains("Tree Climbing")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Tree Climbing")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl60_imgAttribute": {
                    if (cacheAttributes.contains("Front Yard")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("Not Front Yard")) break;
                    item.click();
                    item.click();
                    break;
                }
                case "ctl00_ContentBody_ctlAttributes_dtlAttributeIcons_ctl61_imgAttribute": {
                    if (cacheAttributes.contains("Teamwork Required")) {
                        item.click();
                        break;
                    }
                    if (!cacheNegAttributes.contains("No Teamwork Required")) break;
                    item.click();
                    item.click();
                }
            }
        }
        driver.findElement(By.id((String)"btnSubmit")).click();
        new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                return d.findElement(By.className((String)"submit-for-review-btn")).isDisplayed();
            }
        });
        driver.findElement(By.id((String)"ctl00_ContentBody_uxEditGeocacheLink")).click();
        new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                return d.findElement(By.id((String)"tbLongDesc")).isDisplayed();
            }
        });
        String cacheFullDescription = String.valueOf(cacheSummary) + cacheDescription;
        driver.findElement(By.id((String)"tbLongDesc")).sendKeys(new CharSequence[]{cacheFullDescription});
        if (cacheSubmitForReview) {
            driver.findElement(By.id((String)"ctl00_ContentBody_btnSubmit")).click();
            new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver d) {
                    return d.findElement(By.id((String)"reviewerNoteText")).isDisplayed();
                }
            });
            driver.findElement(By.id((String)"reviewerNoteText")).sendKeys(new CharSequence[]{cacheReviewerNotes});
            driver.findElement(By.id((String)"btnSubmitForReview")).click();
            System.out.println("beenSubmitted");
            new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver d) {
                    return d.findElement(By.className((String)"alert-success")).isDisplayed();
                }
            });
        } else {
            driver.findElement(By.id((String)"ctl00_ContentBody_btnSaveAndPreview")).click();
            new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver d) {
                    return d.findElement(By.className((String)"submit-for-review-btn")).isDisplayed();
                }
            });
        }
        System.out.println("beenCreated");
    }

    private static void updateSmileyGeoArt() {
        driver = new ChromeDriver();
        driver.get("http://www.geocaching.com/account/login");
        WebElement element = driver.findElement(By.name((String)"Username"));
        element.sendKeys(new CharSequence[]{"mtclmbr"});
        element = driver.findElement(By.name((String)"Password"));
        element.sendKeys(new CharSequence[]{"CBH~kafTV8Mx"});
        element.submit();
        try {
            File inputFile = new File("C:\\Users\\christopher.stolte\\Downloads\\20107670_DoorCountySmiley\\20107670_Door County Smiley.gpx");
            SAXBuilder saxBuilder = new SAXBuilder();
            Document document = saxBuilder.build(inputFile);
            System.out.println("Root element :" + document.getRootElement().getName());
            Element classElement = document.getRootElement();
            List smileyList = classElement.getChildren();
            int temp = 0;
            while (temp < smileyList.size()) {
                Element smileyCache = (Element)smileyList.get(temp);
                System.out.println("\nCurrent Element :" + smileyCache.getName());
                if (smileyCache.getName() == "wpt") {
                    Pattern lonPattern;
                    Matcher lonMatcher;
                    smileyLat = Double.parseDouble(smileyCache.getAttributeValue("lat"));
                    smileyLon = Double.parseDouble(smileyCache.getAttributeValue("lon"));
                    List cacheList = smileyCache.getChildren();
                    gcCode = ((Element)cacheList.get(1)).getText();
                    Element gsCache = (Element)cacheList.get(7);
                    List gsList = gsCache.getChildren();
                    Element gsDescription = (Element)gsList.get(10);
                    String rawDescription = gsDescription.getText();
                    Pattern latPattern = Pattern.compile("(Add|Subtract).*North");
                    Matcher latMatcher = latPattern.matcher(rawDescription);
                    if (latMatcher.find()) {
                        String northInfo = latMatcher.group(0);
                        String[] northInfoArr = northInfo.split("\\s+");
                        Double mathLat = Double.parseDouble(northInfoArr[1].trim());
                        finalLat = northInfoArr[0].trim().equals("Add") ? smileyLat + mathLat / 60.0 : smileyLat - mathLat / 60.0;
                    }
                    if ((lonMatcher = (lonPattern = Pattern.compile("(Add|Subtract).*West")).matcher(rawDescription)).find()) {
                        String westInfo = lonMatcher.group(0);
                        String[] westInfoArr = westInfo.split("\\s+");
                        Double mathLon = Double.parseDouble(westInfoArr[1].trim());
                        finalLon = westInfoArr[0].trim().equals("Add") ? smileyLon * -1.0 + mathLon / 60.0 : smileyLon * -1.0 - mathLon / 60.0;
                    }
                    System.out.println(gcCode);
                    System.out.println(smileyLat);
                    System.out.println(smileyLon);
                    System.out.println(finalLat);
                    System.out.println(finalLon);
                    try {
                        TimeUnit.SECONDS.sleep(3L);
                        driver.get("https://coord.info/" + gcCode);
                        new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                            public Boolean apply(WebDriver d) {
                                d.findElement(By.id((String)"ctl00_ContentBody_CoordInfoLinkControl1_uxCoordInfoCode")).isDisplayed();
                                String gcPageCode = driver.findElement(By.id((String)"ctl00_ContentBody_CoordInfoLinkControl1_uxCoordInfoCode")).getText();
                                return gcPageCode.equals(gcCode);
                            }
                        });
                        driver.findElement(By.id((String)"uxLatLonLink")).click();
                        new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                            public Boolean apply(WebDriver d) {
                                return d.findElement(By.className((String)"cc-parse-text")).isDisplayed();
                            }
                        });
                        driver.findElement(By.className((String)"cc-parse-text")).sendKeys(new CharSequence[]{String.valueOf(finalLat) + " -" + finalLon});
                        driver.findElement(By.className((String)"ccu-button")).click();
                        new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                            public Boolean apply(WebDriver d) {
                                return d.findElement(By.className((String)"ccu-parseverify-accept")).isDisplayed();
                            }
                        });
                        driver.findElement(By.className((String)"ccu-parseverify-accept")).click();
                        new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                            public Boolean apply(WebDriver d) {
                                d.findElement(By.id((String)"ctl00_ContentBody_CoordInfoLinkControl1_uxCoordInfoCode")).isDisplayed();
                                String gcPageCode = driver.findElement(By.id((String)"ctl00_ContentBody_CoordInfoLinkControl1_uxCoordInfoCode")).getText();
                                return gcPageCode.equals(gcCode);
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, "ERROR: " + e.toString());
                        driver.quit();
                        driver.close();
                        System.exit(0);
                    }
                }
                ++temp;
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        driver.quit();
        driver.close();
        System.exit(0);
    }

    private static void editWindmillCaches() {
        driver = new ChromeDriver();
        driver.get("http://www.geocaching.com/account/login");
        WebElement element = driver.findElement(By.name((String)"Username"));
        element.sendKeys(new CharSequence[]{"mtclmbr"});
        element = driver.findElement(By.name((String)"Password"));
        element.sendKeys(new CharSequence[]{"CBH~kafTV8Mx"});
        element.submit();
        try {
            driver.get("https://www.geocaching.com/my/default.aspx");
            new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver d) {
                    return d.findElement(By.className((String)"ProfileUsername")).isDisplayed();
                }
            });
            while (driver.findElement(By.partialLinkText((String)"Windmill GeoArt")).isDisplayed()) {
                driver.findElement(By.partialLinkText((String)"Windmill GeoArt")).click();
                new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                    public Boolean apply(WebDriver d) {
                        return d.findElement(By.id((String)"cspGoBack")).isDisplayed();
                    }
                });
                driver.findElement(By.id((String)"cspGoBack")).click();
                new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                    public Boolean apply(WebDriver d) {
                        return d.findElement(By.id((String)"tbShortDesc")).isDisplayed();
                    }
                });
                String longDescription = driver.findElement(By.id((String)"tbLongDesc")).getText();
                longDescription = longDescription.replace("<li>If you need a cache container to help do a power run you can find some near the start in \"17: WindMill GeoArt\". Feel free to replace them if you deem it is missing (ie at least a 5min search and triple check of solve)</li>", "");
                driver.findElement(By.id((String)"tbLongDesc")).clear();
                driver.findElement(By.id((String)"tbLongDesc")).sendKeys(new CharSequence[]{longDescription});
                driver.findElement(By.id((String)"ctl00_ContentBody_chkUnderstand")).click();
                driver.findElement(By.id((String)"ctl00_ContentBody_chkDisclaimer")).click();
                driver.findElement(By.id((String)"ctl00_ContentBody_btnSubmit")).click();
                new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                    public Boolean apply(WebDriver d) {
                        return d.findElement(By.className((String)"Success")).isDisplayed();
                    }
                });
                driver.findElement(By.className((String)"Success")).findElement(By.tagName((String)"a")).click();
                new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                    public Boolean apply(WebDriver d) {
                        return d.findElement(By.id((String)"cspSubmit")).isDisplayed();
                    }
                });
                driver.findElement(By.id((String)"ctl00_ContentBody_GeoNav_logButton")).click();
                new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                    public Boolean apply(WebDriver d) {
                        return d.findElement(By.id((String)"LogText")).isDisplayed();
                    }
                });
                driver.findElement(By.id((String)"LogText")).sendKeys(new CharSequence[]{"Sorry missed the disable from all the WBCB weekend Logs. Statement has been removed. And resubmitted, Thank you for your help."});
                driver.findElement(By.className((String)"btn-submit")).click();
                new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                    public Boolean apply(WebDriver d) {
                        return d.findElement(By.id((String)"cspSubmit")).isDisplayed();
                    }
                });
                driver.findElement(By.id((String)"cspSubmit")).click();
                System.out.println("beenSubmitted");
                new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                    public Boolean apply(WebDriver d) {
                        return d.findElement(By.className((String)"OldWarning")).isDisplayed();
                    }
                });
                driver.get("https://www.geocaching.com/my/default.aspx");
                new WebDriverWait(driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                    public Boolean apply(WebDriver d) {
                        return d.findElement(By.className((String)"ProfileUsername")).isDisplayed();
                    }
                });
            }
            driver.quit();
            driver.close();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "ERROR: " + e.toString());
            driver.quit();
            driver.close();
            System.exit(0);
        }
    }
}

